/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.google.common.base.Stopwatch;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.mixin.DatagenModLoaderAccessor;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={DataGenerator.class})
public class DataGeneratorMixin {
    @Shadow
    @Final
    private static Logger f_123905_;
    @Unique
    private ResourceCache resourceCache;
    @Shadow
    @Final
    private List<DataProvider> f_123908_;
    @Shadow
    @Final
    private Path f_123907_;

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/data/HashCache;keep(Ljava/nio/file/Path;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void runHead(CallbackInfo ci, HashCache hashCache) {
        GatherDataEvent.DataGeneratorConfig dataGeneratorConfig = DatagenModLoaderAccessor.getDataGeneratorConfig();
        if (dataGeneratorConfig != null) {
            dataGeneratorConfig.getMods().stream().filter(GeneratorRegistrationHandler::hasHandlerForModid).forEach(modid -> {
                GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get(modid);
                DataGenerator dataGenerator = (DataGenerator)this;
                Path outputFolder = this.f_123907_;
                if (this.resourceCache == null) {
                    this.resourceCache = ResourceCache.wrap(DatagenModLoaderAccessor.getExistingFileHelper(), hashCache, outputFolder);
                }
                ((ResourceCache.HashCacheWrapper)this.resourceCache).allowWrites(false);
                handler.registerProviders(dataGenerator, DatagenModLoaderAccessor.getExistingFileHelper(), this.resourceCache);
            });
        }
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lcom/google/common/base/Stopwatch;createUnstarted()Lcom/google/common/base/Stopwatch;", shift=At.Shift.AFTER)})
    private void runBeforeGenerators(CallbackInfo ci) {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        for (DataProvider provider : this.f_123908_) {
            if (!(provider instanceof ResourceGenerator.DataProviderInstance)) continue;
            f_123905_.info("Running generator: {}", (Object)provider.m_6055_());
            stopwatch.start();
            ((ResourceGenerator.DataProviderInstance)provider).generate();
            stopwatch.stop();
            f_123905_.info("{} finished after {} ms", (Object)provider.m_6055_(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset();
        }
        if (this.resourceCache != null) {
            ((ResourceCache.HashCacheWrapper)this.resourceCache).allowWrites(true);
        }
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/data/HashCache;purgeStaleAndWrite()V", shift=At.Shift.BEFORE)})
    private void runTail(CallbackInfo ci) {
        if (this.resourceCache != null) {
            ((ResourceCache.HashCacheWrapper)this.resourceCache).finish();
        }
    }
}

